<?php
/**
 * Sngine updater
 * 
 * @package Sngine v2+
 * @author Zamblek
 */

// set absolut & base path
define('ABSPATH',dirname(__FILE__).'/');
define('BASEPATH',dirname($_SERVER['PHP_SELF']));

if(!file_exists(ABSPATH.'includes/config.php')) {

    // get functions
    require(ABSPATH.'includes/functions.php');
    
    /* the config file doesn't exist -> start the installer */
    _redirect('/install');
    
}

// get system configurations
require(ABSPATH.'includes/config.php');

// enviroment settings
if(DEBUGGING) {
    ini_set("display_errors", true);
    error_reporting(E_ALL ^ E_NOTICE);
}else {
    ini_set("display_errors", false);
    error_reporting(0);
}


// get functions
require(ABSPATH.'includes/functions.php');


// connect to the database
$db = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
$db->set_charset('utf8');
if(mysqli_connect_error()) {
    _error(DB_ERROR);
}


// install
if(isset($_POST['submit'])) {

    // [0] check valid purchase code
    /* get licence key */
    try {
      $licence_key = _get_licence_key($_POST['purchase_code']);
      if(is_empty($_POST['purchase_code']) || $licence_key === false) {
        _error("Error", "Please enter a valid purchase code");
      }
    }catch (Exception $e) {
      _error("Error", $e->getMessage());
    }
    
    
    // [1] update the sngine tables
    $structure = "
CREATE TABLE `posts_audios` (
  `audio_id` int(10) unsigned NOT NULL auto_increment,
  `post_id` int(10) unsigned NOT NULL,
  `source` varchar(255) NOT NULL,
  PRIMARY KEY (`audio_id`)
) ENGINE=MyISAM row_format=DYNAMIC;

CREATE TABLE `posts_files` (
  `file_id` int(10) unsigned NOT NULL auto_increment,
  `post_id` int(10) unsigned NOT NULL,
  `source` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=MyISAM row_format=DYNAMIC;

ALTER TABLE `system_options`
  DROP COLUMN `system_domain`
  , DROP COLUMN `users_can_register`
  , DROP COLUMN `google_analytics`
  , MODIFY COLUMN `ID` int(10) unsigned NOT NULL auto_increment
  , MODIFY COLUMN `games_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , MODIFY COLUMN `max_avatar_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , MODIFY COLUMN `max_cover_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , MODIFY COLUMN `max_photo_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , MODIFY COLUMN `videos_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , MODIFY COLUMN `max_video_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , MODIFY COLUMN `min_results` int(10) unsigned NOT NULL DEFAULT '5'
  , MODIFY COLUMN `min_results_even` int(10) unsigned NOT NULL DEFAULT '6'
  , MODIFY COLUMN `max_results` int(10) unsigned NOT NULL DEFAULT '10'
  , ADD COLUMN `system_public` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `system_cached` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `system_keywords` text NULL
  , ADD COLUMN `pages_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `groups_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `profile_notification_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `geolocation_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `registration_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `getting_started` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `delete_accounts_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `max_accounts` int(10) unsigned NOT NULL DEFAULT '0'
  , ADD COLUMN `chat_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `chat_status_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `uploads_prefix` varchar(255) NOT NULL DEFAULT 'sngine'
  , ADD COLUMN `photos_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `video_extensions` text NULL
  , ADD COLUMN `audio_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `max_audio_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , ADD COLUMN `audio_extensions` text NULL
  , ADD COLUMN `file_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `max_file_size` int(10) unsigned NOT NULL DEFAULT '5120'
  , ADD COLUMN `file_extensions` text NULL
  , ADD COLUMN `censored_words_enabled` enum('1','0') NOT NULL DEFAULT '1'
  , ADD COLUMN `censored_words` text NULL
  , ADD COLUMN `data_heartbeat` int(10) unsigned NOT NULL DEFAULT '5'
  , ADD COLUMN `chat_heartbeat` int(10) unsigned NOT NULL DEFAULT '5'
  , ADD COLUMN `offline_time` int(10) unsigned NOT NULL DEFAULT '10'
  , ADD COLUMN `analytics_code` text NULL
  , ADD COLUMN `css_customized` enum('1','0') NOT NULL DEFAULT '0'
  , ADD COLUMN `css_background` varchar(50) NULL
  , ADD COLUMN `css_link_color` varchar(50) NULL
  , ADD COLUMN `css_header` varchar(50) NULL
  , ADD COLUMN `css_header_search` varchar(50) NULL
  , ADD COLUMN `css_btn_primary` varchar(50) NULL
  , ADD COLUMN `css_menu_background` varchar(50) NULL;

ALTER TABLE `users`
  ADD COLUMN `user_started` enum('0','1') NOT NULL DEFAULT '0';
";
    

    $db->multi_query($structure) or _error("Error", $db->error);
    // flush multi_queries
    do{} while(mysqli_more_results($db) && mysqli_next_result($db));


    // [2] update system settings
    $db->query(sprintf("UPDATE system_options SET system_licence = %s, system_kernel = %s", secure($licence_key), secure($sngine_kernel) )) or _error("Error #101", $db->error);


     // [3] create config file
    $config_string = '<?php  
    define("DB_NAME", "'.DB_NAME. '");
    define("DB_USER", "'.DB_USER. '");
    define("DB_PASSWORD", "'.DB_PASSWORD. '");
    define("DB_HOST", "'.DB_HOST. '");
    define("DEBUGGING", false);
    define("DEFAULT_LOCALE", "en_US");
    define("SNGINE_KEY", "'. $licence_key. '");
    
    ?>';
    
    $config_file = 'includes/config.php';
    $handle = fopen($config_file, 'w') or _error("System Error", "Cannot create the config file");
    
    fwrite($handle, $config_string);
    fclose($handle);

    // [4] Done
    _error("System Updated", "Sngine has been updated to 2.2");
}

?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge"> 
        <meta name="viewport" content="width=device-width, initial-scale=1"> 
        
        <title>Sngine v2.2 &rsaquo; Update</title>
        
        <link rel="stylesheet" type="text/css" href="includes/assets/js/installer/installer.min.css" />
        <script src="includes/assets/js/installer/modernizr.custom.js"></script>
    </head>

    <body>
        
        <div class="container">

            <div class="fs-form-wrap" id="fs-form-wrap">
                
                <div class="fs-title">
                    <h1>Sngine v2.2 Update</h1>
                </div>
                
                <form id="myform" class="fs-form fs-form-full" autocomplete="off" action="update.php" method="post">
                    <ol class="fs-fields">

                        <li>
                            <p class="fs-field-label fs-anim-upper">
                                Welcome to <strong>Sngine</strong> updating process! Just fill in the information below.
                            </p>
                        </li>

                        <li>
                            <label class="fs-field-label fs-anim-upper" for="purchase_code" data-info="The purchase code of Sngine">Purchase Code</label>
                            <input class="fs-anim-lower" id="purchase_code" name="purchase_code" type="text" placeholder="xxx-xx-xxxx" required/>
                        </li>

                    </ol>
                    <button class="fs-submit" name="submit" type="submit">Update</button>
                </form>

            </div>

        </div>
        
        <script src="includes/assets/js/installer/classie.js"></script>
        <script src="includes/assets/js/installer/fullscreenForm.js"></script>
        <script>
            (function() {
                var formWrap = document.getElementById( 'fs-form-wrap' );
                new FForm( formWrap, {
                    onReview : function() {
                        classie.add( document.body, 'overview' );
                    }
                } );
            })();
        </script>

    </body>
</html>